/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.component;

import discord4j.core.object.component.ActionComponent;
import discord4j.core.object.component.MessageComponent;
import discord4j.core.object.reaction.ReactionEmoji;
import discord4j.discordjson.json.ComponentData;
import discord4j.discordjson.json.SelectOptionData;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class SelectMenu
extends ActionComponent {
    public static SelectMenu of(String customId, Option ... options) {
        return SelectMenu.of(customId, Arrays.asList(options));
    }

    public static SelectMenu of(String customId, List<Option> options) {
        return new SelectMenu(ComponentData.builder().type(MessageComponent.Type.SELECT_MENU.getValue()).customId(customId).options(options.stream().map(opt -> ((Option)opt).data).collect(Collectors.toList())).build());
    }

    SelectMenu(ComponentData data) {
        super(data);
    }

    public String getCustomId() {
        return this.getData().customId().toOptional().orElseThrow(IllegalStateException::new);
    }

    public Optional<String> getPlaceholder() {
        return this.getData().customId().toOptional();
    }

    public int getMinValues() {
        return this.getData().minValues().toOptional().orElse(1);
    }

    public int getMaxValues() {
        return this.getData().maxValues().toOptional().orElse(1);
    }

    public List<Option> getOptions() {
        List<SelectOptionData> options = this.getData().options().toOptional().orElseThrow(IllegalStateException::new);
        return options.stream().map(Option::new).collect(Collectors.toList());
    }

    public boolean isDisabled() {
        return this.getData().disabled().toOptional().orElse(false);
    }

    public SelectMenu withPlaceholder(String placeholder) {
        return new SelectMenu(ComponentData.builder().from(this.getData()).placeholder(placeholder).build());
    }

    public SelectMenu withMinValues(int minValues) {
        return new SelectMenu(ComponentData.builder().from(this.getData()).minValues(minValues).build());
    }

    public SelectMenu withMaxValues(int maxValues) {
        return new SelectMenu(ComponentData.builder().from(this.getData()).maxValues(maxValues).build());
    }

    public static class Option {
        private final SelectOptionData data;

        public static Option of(String label, String value) {
            return Option.of(label, value, false);
        }

        public static Option ofDefault(String label, String value) {
            return Option.of(label, value, true);
        }

        private static Option of(String label, String value, boolean isDefault) {
            return new Option(SelectOptionData.builder().label(label).value(value).isDefault(isDefault).build());
        }

        Option(SelectOptionData data) {
            this.data = data;
        }

        public String getLabel() {
            return this.data.label();
        }

        public String getValue() {
            return this.data.value();
        }

        public Optional<String> getDescription() {
            return this.data.description().toOptional();
        }

        public Optional<ReactionEmoji> getEmoji() {
            return this.data.emoji().toOptional().map(ReactionEmoji::of);
        }

        public boolean isDefault() {
            return this.data.isDefault().toOptional().orElse(false);
        }

        public Option withDescription(String description) {
            return new Option(SelectOptionData.builder().from(this.data).description(description).build());
        }

        public Option withEmoji(ReactionEmoji emoji) {
            return new Option(SelectOptionData.builder().from(this.data).emoji(emoji.asEmojiData()).build());
        }

        public Option withDefault(boolean isDefault) {
            return new Option(SelectOptionData.builder().from(this.data).isDefault(isDefault).build());
        }
    }
}

