/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.entity.channel;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.ExtendedPermissionOverwrite;
import discord4j.core.object.PermissionOverwrite;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.Member;
import discord4j.core.object.entity.channel.BaseChannel;
import discord4j.core.object.entity.channel.GuildChannel;
import discord4j.core.retriever.EntityRetrievalStrategy;
import discord4j.core.util.OrderUtil;
import discord4j.core.util.PermissionUtil;
import discord4j.discordjson.json.ChannelData;
import discord4j.discordjson.json.ImmutablePermissionsEditRequest;
import discord4j.discordjson.json.OverwriteData;
import discord4j.discordjson.json.PermissionsEditRequest;
import discord4j.rest.util.PermissionSet;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

class BaseGuildChannel
extends BaseChannel
implements GuildChannel {
    BaseGuildChannel(GatewayDiscordClient gateway, ChannelData data) {
        super(gateway, data);
    }

    @Override
    public final Snowflake getGuildId() {
        return this.getData().guildId().toOptional().map(Snowflake::of).orElseThrow(IllegalStateException::new);
    }

    @Override
    public final Mono<Guild> getGuild() {
        return this.getClient().getGuildById(this.getGuildId());
    }

    @Override
    public Mono<Guild> getGuild(EntityRetrievalStrategy retrievalStrategy) {
        return this.getClient().withRetrievalStrategy(retrievalStrategy).getGuildById(this.getGuildId());
    }

    @Override
    public final Set<ExtendedPermissionOverwrite> getPermissionOverwrites() {
        return this.getData().permissionOverwrites().toOptional().map(permissionOverwrites -> {
            long guildId = this.getGuildId().asLong();
            long channelId = this.getId().asLong();
            return permissionOverwrites.stream().map(overwriteData -> new ExtendedPermissionOverwrite(this.getClient(), (OverwriteData)overwriteData, guildId, channelId)).collect(Collectors.toSet());
        }).orElse(Collections.emptySet());
    }

    @Override
    public Optional<ExtendedPermissionOverwrite> getOverwriteForMember(Snowflake memberId) {
        return this.getPermissionOverwrites().stream().filter(overwrite -> overwrite.getMemberId().map(memberId::equals).orElse(false)).findFirst();
    }

    @Override
    public Optional<ExtendedPermissionOverwrite> getOverwriteForRole(Snowflake roleId) {
        return this.getPermissionOverwrites().stream().filter(overwrite -> overwrite.getRoleId().map(roleId::equals).orElse(false)).findFirst();
    }

    @Override
    public Mono<PermissionSet> getEffectivePermissions(Snowflake memberId) {
        Mono<Member> getMember = this.getClient().getMemberById(this.getGuildId(), memberId);
        Mono getBasePerms = getMember.flatMap(Member::getBasePermissions);
        return Mono.zip(getMember, getBasePerms, (member, basePerms) -> {
            PermissionOverwrite everyoneOverwrite = this.getOverwriteForRole(this.getGuildId()).orElse(null);
            List<PermissionOverwrite> roleOverwrites = member.getRoleIds().stream().map(this::getOverwriteForRole).flatMap(o -> o.map(Stream::of).orElseGet(Stream::empty)).collect(Collectors.toList());
            PermissionOverwrite memberOverwrite = this.getOverwriteForMember(member.getId()).orElse(null);
            return PermissionUtil.computePermissions(basePerms, everyoneOverwrite, roleOverwrites, memberOverwrite);
        });
    }

    @Override
    public final String getName() {
        return this.getData().name().toOptional().orElseThrow(IllegalStateException::new);
    }

    @Override
    public int getRawPosition() {
        return this.getData().position().toOptional().orElseThrow(IllegalStateException::new);
    }

    @Override
    public final Mono<Integer> getPosition() {
        return this.getGuild().flatMapMany(Guild::getChannels).transform(OrderUtil::orderGuildChannels).collectList().map(channels -> channels.indexOf(this));
    }

    @Override
    public Mono<Void> addMemberOverwrite(Snowflake memberId, PermissionOverwrite overwrite, @Nullable String reason) {
        PermissionSet allow = overwrite.getAllowed();
        PermissionSet deny = overwrite.getDenied();
        ImmutablePermissionsEditRequest request = PermissionsEditRequest.builder().allow(allow.getRawValue()).deny(deny.getRawValue()).type("member").build();
        return this.getClient().getRestClient().getChannelService().editChannelPermissions(this.getId().asLong(), memberId.asLong(), request, reason);
    }

    @Override
    public Mono<Void> addRoleOverwrite(Snowflake roleId, PermissionOverwrite overwrite, @Nullable String reason) {
        PermissionSet allow = overwrite.getAllowed();
        PermissionSet deny = overwrite.getDenied();
        ImmutablePermissionsEditRequest request = PermissionsEditRequest.builder().allow(allow.getRawValue()).deny(deny.getRawValue()).type("role").build();
        return this.getClient().getRestClient().getChannelService().editChannelPermissions(this.getId().asLong(), roleId.asLong(), request, reason);
    }

    @Override
    public String toString() {
        return "BaseGuildChannel{} " + super.toString();
    }
}

