/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.shard;

import discord4j.core.shard.KeyStore;
import discord4j.store.api.Store;
import discord4j.store.api.util.WithinRangePredicate;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;
import reactor.util.function.Tuple2;

public class ShardAwareStore<K extends Comparable<K>, V>
implements Store<K, V> {
    private final Store<K, V> valueStore;
    private final KeyStore<K> keyStore;

    public ShardAwareStore(Store<K, V> valueStore, KeyStore<K> keyStore) {
        this.valueStore = valueStore;
        this.keyStore = keyStore;
    }

    @Override
    public Mono<Void> save(K key, V value) {
        return Mono.subscriberContext().flatMap(ctx -> this.valueStore.save((Comparable)key, value).then(this.addKey((Context)ctx, key)));
    }

    @Override
    public Mono<Void> save(Publisher<Tuple2<K, V>> entryStream) {
        return Mono.subscriberContext().flatMap(ctx -> Flux.from(entryStream).flatMap(t -> this.valueStore.save((Comparable)t.getT1(), t.getT2()).then(this.addKey((Context)ctx, (K)((Comparable)t.getT1())))).then());
    }

    @Override
    public Mono<V> find(K id) {
        return this.valueStore.find(id);
    }

    @Override
    public Flux<V> findInRange(K start, K end) {
        return this.valueStore.findInRange(start, end);
    }

    @Override
    public Mono<Long> count() {
        return this.valueStore.count();
    }

    @Override
    public Mono<Void> delete(K id) {
        return Mono.subscriberContext().flatMap(ctx -> this.valueStore.delete((Comparable)id).then(this.removeKey((Context)ctx, id)));
    }

    @Override
    public Mono<Void> delete(Publisher<K> ids) {
        return Mono.subscriberContext().flatMap(ctx -> Flux.from(ids).flatMap(id -> this.valueStore.delete((Comparable)id).then(this.removeKey((Context)ctx, (K)id))).then());
    }

    @Override
    public Mono<Void> deleteInRange(K start, K end) {
        return Mono.subscriberContext().flatMap(ctx -> this.valueStore.keys().filter(new WithinRangePredicate<Comparable>((Comparable)start, (Comparable)end)).flatMap(id -> this.valueStore.delete((Comparable)id).then(this.removeKey((Context)ctx, (K)id))).then());
    }

    @Override
    public Mono<Void> deleteAll() {
        return Mono.subscriberContext().flatMap(ctx -> this.valueStore.deleteAll().then(this.clearKeys((Context)ctx)));
    }

    @Override
    public Flux<K> keys() {
        return this.valueStore.keys();
    }

    @Override
    public Flux<V> values() {
        return this.valueStore.values();
    }

    @Override
    public Mono<Void> invalidate() {
        return Mono.subscriberContext().flatMap(ctx -> this.delete((Publisher<K>)this.getKeys((Context)ctx)).then(this.clearKeys((Context)ctx)));
    }

    private Mono<Void> addKey(Context ctx, K key) {
        return Mono.fromRunnable(() -> ctx.getOrEmpty("discord4j.shard").ifPresent(id -> this.keyStore.add((int)id, (Comparable)key)));
    }

    private Mono<Void> removeKey(Context ctx, K key) {
        return Mono.fromRunnable(() -> ctx.getOrEmpty("discord4j.shard").ifPresent(id -> this.keyStore.remove((int)id, (Comparable)key)));
    }

    private Mono<Void> clearKeys(Context ctx) {
        return Mono.fromRunnable(() -> ctx.getOrEmpty("discord4j.shard").ifPresent(this.keyStore::clear));
    }

    private Flux<K> getKeys(Context ctx) {
        return Flux.defer(() -> ctx.getOrEmpty("discord4j.shard").map(id -> Flux.fromIterable(this.keyStore.keys((int)id))).orElseGet(Flux::empty));
    }

    public String toString() {
        return "ShardAwareStore{valueStore=" + this.valueStore + '}';
    }
}

