/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.core.object.PermissionOverwrite;
import discord4j.core.object.entity.channel.Channel;
import discord4j.core.spec.AuditSpec;
import discord4j.discordjson.json.ChannelCreateRequest;
import discord4j.discordjson.json.ImmutableChannelCreateRequest;
import discord4j.discordjson.json.OverwriteData;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import reactor.util.annotation.Nullable;

public class CategoryCreateSpec
implements AuditSpec<ChannelCreateRequest> {
    private final ImmutableChannelCreateRequest.Builder requestBuilder = ChannelCreateRequest.builder().type(Channel.Type.GUILD_CATEGORY.getValue());
    @Nullable
    private String reason;

    public CategoryCreateSpec setName(String name) {
        this.requestBuilder.name(name);
        return this;
    }

    public CategoryCreateSpec setPosition(int position) {
        this.requestBuilder.position(position);
        return this;
    }

    public CategoryCreateSpec setPermissionOverwrites(Set<? extends PermissionOverwrite> permissionOverwrites) {
        List<OverwriteData> raw = permissionOverwrites.stream().map(o -> OverwriteData.builder().id(o.getTargetId().asString()).type(o.getType().getValue()).allow(o.getAllowed().getRawValue()).deny(o.getDenied().getRawValue()).build()).collect(Collectors.toList());
        this.requestBuilder.permissionOverwrites(raw);
        return this;
    }

    public CategoryCreateSpec setReason(@Nullable String reason) {
        this.reason = reason;
        return this;
    }

    @Override
    @Nullable
    public String getReason() {
        return this.reason;
    }

    @Override
    public ChannelCreateRequest asRequest() {
        return this.requestBuilder.build();
    }
}

