/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.core.object.component.LayoutComponent;
import discord4j.core.object.component.MessageComponent;
import discord4j.core.object.entity.Message;
import discord4j.core.spec.EmbedCreateSpec;
import discord4j.core.spec.Spec;
import discord4j.discordjson.json.AllowedMentionsData;
import discord4j.discordjson.json.ComponentData;
import discord4j.discordjson.json.EmbedData;
import discord4j.discordjson.json.MessageEditRequest;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.AllowedMentions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import reactor.util.annotation.Nullable;

public class MessageEditSpec
implements Spec<MessageEditRequest> {
    private Possible<Optional<String>> content = Possible.absent();
    private Possible<Optional<List<EmbedData>>> embeds = Possible.absent();
    private Possible<Optional<AllowedMentionsData>> allowedMentions = Possible.absent();
    private Possible<Optional<Integer>> flags = Possible.absent();
    private Possible<Optional<List<ComponentData>>> components = Possible.absent();

    public MessageEditSpec setContent(@Nullable String content) {
        this.content = Possible.of(Optional.ofNullable(content));
        return this;
    }

    @Deprecated
    public MessageEditSpec setEmbed(@Nullable Consumer<? super EmbedCreateSpec> spec) {
        if (spec != null) {
            EmbedCreateSpec mutatedSpec = new EmbedCreateSpec();
            spec.accept(mutatedSpec);
            this.embeds = Possible.of(Optional.of(Collections.singletonList(mutatedSpec.asRequest())));
        } else {
            this.embeds = Possible.of(Optional.empty());
        }
        return this;
    }

    public MessageEditSpec addEmbed(Consumer<? super EmbedCreateSpec> spec) {
        EmbedCreateSpec mutatedSpec = new EmbedCreateSpec();
        spec.accept(mutatedSpec);
        if (this.embeds.isAbsent() || !this.embeds.get().isPresent()) {
            this.embeds = Possible.of(Optional.of(new ArrayList(1)));
        }
        this.embeds.get().get().add(mutatedSpec.asRequest());
        return this;
    }

    public MessageEditSpec removeEmbeds() {
        this.embeds = Possible.of(Optional.empty());
        return this;
    }

    public MessageEditSpec setAllowedMentions(@Nullable AllowedMentions allowedMentions) {
        this.allowedMentions = Possible.of(Optional.ofNullable(allowedMentions).map(AllowedMentions::toData));
        return this;
    }

    public MessageEditSpec setFlags(Message.Flag ... flags) {
        this.flags = flags != null ? Possible.of(Optional.of(Arrays.stream(flags).mapToInt(Message.Flag::getValue).reduce(0, (left, right) -> left | right))) : Possible.of(Optional.empty());
        return this;
    }

    public MessageEditSpec setComponents(LayoutComponent ... components) {
        return this.setComponents(Arrays.asList(components));
    }

    public MessageEditSpec setComponents(List<LayoutComponent> components) {
        this.components = Possible.of(Optional.of(components.stream().map(MessageComponent::getData).collect(Collectors.toList())));
        return this;
    }

    @Override
    public MessageEditRequest asRequest() {
        return MessageEditRequest.builder().content(this.content).embeds(this.embeds).allowedMentions(this.allowedMentions).flags(this.flags).components(this.components).build();
    }
}

