/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.common.util.Snowflake;
import discord4j.core.object.PermissionOverwrite;
import discord4j.core.spec.AuditSpec;
import discord4j.discordjson.json.ChannelModifyRequest;
import discord4j.discordjson.json.ImmutableChannelModifyRequest;
import discord4j.discordjson.json.OverwriteData;
import discord4j.discordjson.possible.Possible;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import reactor.util.annotation.Nullable;

public class TextChannelEditSpec
implements AuditSpec<ChannelModifyRequest> {
    private final ImmutableChannelModifyRequest.Builder requestBuilder = ChannelModifyRequest.builder();
    @Nullable
    private String reason;

    public TextChannelEditSpec setName(String name) {
        this.requestBuilder.name(name);
        return this;
    }

    public TextChannelEditSpec setPosition(int position) {
        this.requestBuilder.position(position);
        return this;
    }

    public TextChannelEditSpec setTopic(String topic) {
        this.requestBuilder.topic(topic);
        return this;
    }

    public TextChannelEditSpec setNsfw(boolean nsfw) {
        this.requestBuilder.nsfw(nsfw);
        return this;
    }

    public TextChannelEditSpec setPermissionOverwrites(Set<? extends PermissionOverwrite> permissionOverwrites) {
        List<OverwriteData> raw = permissionOverwrites.stream().map(o -> OverwriteData.builder().id(o.getTargetId().asString()).type(o.getType().getValue()).allow(o.getAllowed().getRawValue()).deny(o.getDenied().getRawValue()).build()).collect(Collectors.toList());
        this.requestBuilder.permissionOverwrites(raw);
        return this;
    }

    public TextChannelEditSpec setParentId(@Nullable Snowflake parentId) {
        this.requestBuilder.parentId(parentId == null ? Possible.of(Optional.empty()) : Possible.of(Optional.of(parentId.asString())));
        return this;
    }

    public TextChannelEditSpec setRateLimitPerUser(int rateLimitPerUser) {
        this.requestBuilder.rateLimitPerUser(rateLimitPerUser);
        return this;
    }

    public TextChannelEditSpec setReason(@Nullable String reason) {
        this.reason = reason;
        return this;
    }

    @Override
    @Nullable
    public String getReason() {
        return this.reason;
    }

    @Override
    public ChannelModifyRequest asRequest() {
        return this.requestBuilder.build();
    }
}

