/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.request;

import discord4j.rest.http.client.ClientException;
import io.netty.handler.codec.http.HttpHeaders;
import java.time.Duration;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.context.Context;

public class RateLimitRetryOperator {
    private static final Logger log = Loggers.getLogger(RateLimitRetryOperator.class);
    private final Scheduler backoffScheduler;

    public RateLimitRetryOperator(Scheduler backoffScheduler) {
        this.backoffScheduler = backoffScheduler;
    }

    public Publisher<Context> apply(Flux<Throwable> errors) {
        return errors.index().concatMap(tuple -> this.retry((Throwable)tuple.getT2(), (Long)tuple.getT1() + 1L));
    }

    private Publisher<Context> retry(Throwable error, long iteration) {
        if (!this.isRateLimitError(error)) {
            return Mono.error(error);
        }
        ClientException clientException = (ClientException)error;
        HttpHeaders headers = clientException.getHeaders();
        try {
            boolean global = Boolean.parseBoolean(headers.get("X-RateLimit-Global"));
            Context context = Context.of("iteration", iteration);
            String retryAfter = headers.get("Retry-After");
            String resetAfter = headers.get("X-RateLimit-Reset-After");
            if (global) {
                Duration fixedBackoff = Duration.ofMillis(Long.parseLong(retryAfter));
                return this.retryMono(fixedBackoff).thenReturn(context);
            }
            if (resetAfter != null) {
                long resetAt = (long)(Double.parseDouble(resetAfter) * 1000.0);
                Duration fixedBackoff = Duration.ofMillis(resetAt);
                return this.retryMono(fixedBackoff).thenReturn(context);
            }
            Duration fixedBackoff = Duration.ofSeconds(Long.parseLong(retryAfter));
            return this.retryMono(fixedBackoff).thenReturn(context);
        }
        catch (Exception e) {
            log.error("Unable to parse rate limit headers: {}", headers);
            return Mono.error(e);
        }
    }

    private boolean isRateLimitError(Throwable error) {
        if (error instanceof ClientException) {
            ClientException clientException = (ClientException)error;
            return clientException.getStatus().code() == 429;
        }
        return false;
    }

    private Mono<Long> retryMono(Duration delay) {
        if (delay == Duration.ZERO) {
            return Mono.just(0L);
        }
        return Mono.delay(delay, this.backoffScheduler);
    }
}

