/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.event.domain.interaction;

import discord4j.common.annotations.Experimental;
import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.event.domain.interaction.ApplicationCommandInteractionEvent;
import discord4j.core.object.command.ApplicationCommandInteraction;
import discord4j.core.object.command.Interaction;
import discord4j.core.object.entity.User;
import discord4j.core.retriever.EntityRetrievalStrategy;
import discord4j.gateway.ShardInfo;
import reactor.core.publisher.Mono;

@Experimental
public class UserInteractionEvent
extends ApplicationCommandInteractionEvent {
    public UserInteractionEvent(GatewayDiscordClient gateway, ShardInfo shardInfo, Interaction interaction) {
        super(gateway, shardInfo, interaction);
    }

    public User getResolvedUser() {
        return (User)this.getInteraction().getCommandInteraction().flatMap(ApplicationCommandInteraction::getResolved).flatMap(it -> it.getUser(this.getTargetId())).orElseThrow(IllegalStateException::new);
    }

    public Snowflake getTargetId() {
        return (Snowflake)this.getInteraction().getCommandInteraction().flatMap(ApplicationCommandInteraction::getTargetId).orElseThrow(IllegalStateException::new);
    }

    public Mono<User> getTargetUser() {
        return this.getClient().getUserById(this.getTargetId());
    }

    public Mono<User> getTargetUser(EntityRetrievalStrategy retrievalStrategy) {
        return this.getClient().withRetrievalStrategy(retrievalStrategy).getUserById(this.getTargetId());
    }
}

