/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.AllowedMentionsData;
import discord4j.discordjson.json.AttachmentData;
import discord4j.discordjson.json.ComponentData;
import discord4j.discordjson.json.EmbedData;
import discord4j.discordjson.json.WebhookMessageEditRequest;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

@Generated(from="WebhookMessageEditRequest", generator="Immutables")
public final class ImmutableWebhookMessageEditRequest
implements WebhookMessageEditRequest {
    private final String content_value;
    private final boolean content_absent;
    private final List<EmbedData> embeds_value;
    private final boolean embeds_absent;
    private final AllowedMentionsData allowedMentions_value;
    private final boolean allowedMentions_absent;
    private final List<AttachmentData> attachments_value;
    private final boolean attachments_absent;
    private final List<ComponentData> components_value;
    private final boolean components_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableWebhookMessageEditRequest(Possible<Optional<String>> content, Possible<Optional<List<EmbedData>>> embeds, Possible<Optional<AllowedMentionsData>> allowedMentions, Possible<Optional<List<AttachmentData>>> attachments, Possible<List<ComponentData>> components) {
        Possible content$impl = content;
        Possible embeds$impl = embeds;
        Possible allowedMentions$impl = allowedMentions;
        Possible attachments$impl = attachments;
        Possible<List<ComponentData>> components$impl = components;
        this.content_value = Possible.flatOpt(content$impl).orElse(null);
        this.content_absent = content$impl.isAbsent();
        this.embeds_value = Possible.flatOpt(embeds$impl).orElse(null);
        this.embeds_absent = embeds$impl.isAbsent();
        this.allowedMentions_value = Possible.flatOpt(allowedMentions$impl).orElse(null);
        this.allowedMentions_absent = allowedMentions$impl.isAbsent();
        this.attachments_value = Possible.flatOpt(attachments$impl).orElse(null);
        this.attachments_absent = attachments$impl.isAbsent();
        this.components_value = components$impl.toOptional().orElse(null);
        this.components_absent = components$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutableWebhookMessageEditRequest(ImmutableWebhookMessageEditRequest original, Possible<Optional<String>> content, Possible<Optional<List<EmbedData>>> embeds, Possible<Optional<AllowedMentionsData>> allowedMentions, Possible<Optional<List<AttachmentData>>> attachments, Possible<List<ComponentData>> components) {
        Possible content$impl = content;
        Possible embeds$impl = embeds;
        Possible allowedMentions$impl = allowedMentions;
        Possible attachments$impl = attachments;
        Possible<List<ComponentData>> components$impl = components;
        this.content_value = Possible.flatOpt(content$impl).orElse(null);
        this.content_absent = content$impl.isAbsent();
        this.embeds_value = Possible.flatOpt(embeds$impl).orElse(null);
        this.embeds_absent = embeds$impl.isAbsent();
        this.allowedMentions_value = Possible.flatOpt(allowedMentions$impl).orElse(null);
        this.allowedMentions_absent = allowedMentions$impl.isAbsent();
        this.attachments_value = Possible.flatOpt(attachments$impl).orElse(null);
        this.attachments_absent = attachments$impl.isAbsent();
        this.components_value = components$impl.toOptional().orElse(null);
        this.components_absent = components$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="content")
    public Possible<Optional<String>> content() {
        return this.content_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.content_value));
    }

    @Override
    @JsonProperty(value="embeds")
    public Possible<Optional<List<EmbedData>>> embeds() {
        return this.embeds_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.embeds_value));
    }

    @Override
    @JsonProperty(value="allowed_mentions")
    public Possible<Optional<AllowedMentionsData>> allowedMentions() {
        return this.allowedMentions_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.allowedMentions_value));
    }

    @Override
    @JsonProperty(value="attachments")
    public Possible<Optional<List<AttachmentData>>> attachments() {
        return this.attachments_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.attachments_value));
    }

    @Override
    @JsonProperty(value="components")
    public Possible<List<ComponentData>> components() {
        return this.components_absent ? Possible.absent() : Possible.of(this.components_value);
    }

    public ImmutableWebhookMessageEditRequest withContent(Possible<Optional<String>> value) {
        Possible<Optional<String>> newValue = Objects.requireNonNull(value);
        return new ImmutableWebhookMessageEditRequest(this, newValue, this.embeds(), this.allowedMentions(), this.attachments(), this.components());
    }

    @Deprecated
    public ImmutableWebhookMessageEditRequest withContent(@Nullable String value) {
        Possible<Optional<String>> newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableWebhookMessageEditRequest(this, newValue, this.embeds(), this.allowedMentions(), this.attachments(), this.components());
    }

    public ImmutableWebhookMessageEditRequest withContentOrNull(@Nullable String value) {
        Possible<Optional<String>> newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableWebhookMessageEditRequest(this, newValue, this.embeds(), this.allowedMentions(), this.attachments(), this.components());
    }

    public ImmutableWebhookMessageEditRequest withEmbeds(Possible<? extends Optional<? extends List<? extends EmbedData>>> possible) {
        Possible<Optional<List<EmbedData>>> newValue = Objects.requireNonNull(possible);
        return new ImmutableWebhookMessageEditRequest(this, this.content(), newValue, this.allowedMentions(), this.attachments(), this.components());
    }

    @Deprecated
    public ImmutableWebhookMessageEditRequest withEmbeds(@Nullable Iterable<EmbedData> elements) {
        Possible<Optional<List<EmbedData>>> newValue = Possible.of(Optional.ofNullable(elements).map(els -> StreamSupport.stream(els.spliterator(), false).collect(Collectors.toList())));
        return new ImmutableWebhookMessageEditRequest(this, this.content(), newValue, this.allowedMentions(), this.attachments(), this.components());
    }

    public ImmutableWebhookMessageEditRequest withEmbedsOrNull(@Nullable Iterable<? extends EmbedData> elements) {
        Possible<Optional<List<EmbedData>>> newValue = Possible.of(Optional.ofNullable(elements).map(els -> StreamSupport.stream(els.spliterator(), false).collect(Collectors.toList())));
        return new ImmutableWebhookMessageEditRequest(this, this.content(), newValue, this.allowedMentions(), this.attachments(), this.components());
    }

    @SafeVarargs
    public final ImmutableWebhookMessageEditRequest withEmbeds(EmbedData ... elements) {
        Possible<Optional<List<EmbedData>>> newValue = Possible.of(Optional.of(Arrays.asList(elements)));
        return new ImmutableWebhookMessageEditRequest(this, this.content(), newValue, this.allowedMentions(), this.attachments(), this.components());
    }

    public ImmutableWebhookMessageEditRequest withAllowedMentions(Possible<Optional<AllowedMentionsData>> value) {
        Possible<Optional<AllowedMentionsData>> newValue = Objects.requireNonNull(value);
        return new ImmutableWebhookMessageEditRequest(this, this.content(), this.embeds(), newValue, this.attachments(), this.components());
    }

    @Deprecated
    public ImmutableWebhookMessageEditRequest withAllowedMentions(@Nullable AllowedMentionsData value) {
        Possible<Optional<AllowedMentionsData>> newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableWebhookMessageEditRequest(this, this.content(), this.embeds(), newValue, this.attachments(), this.components());
    }

    public ImmutableWebhookMessageEditRequest withAllowedMentionsOrNull(@Nullable AllowedMentionsData value) {
        Possible<Optional<AllowedMentionsData>> newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableWebhookMessageEditRequest(this, this.content(), this.embeds(), newValue, this.attachments(), this.components());
    }

    public ImmutableWebhookMessageEditRequest withAttachments(Possible<? extends Optional<? extends List<? extends AttachmentData>>> possible) {
        Possible<Optional<List<AttachmentData>>> newValue = Objects.requireNonNull(possible);
        return new ImmutableWebhookMessageEditRequest(this, this.content(), this.embeds(), this.allowedMentions(), newValue, this.components());
    }

    @Deprecated
    public ImmutableWebhookMessageEditRequest withAttachments(@Nullable Iterable<AttachmentData> elements) {
        Possible<Optional<List<AttachmentData>>> newValue = Possible.of(Optional.ofNullable(elements).map(els -> StreamSupport.stream(els.spliterator(), false).collect(Collectors.toList())));
        return new ImmutableWebhookMessageEditRequest(this, this.content(), this.embeds(), this.allowedMentions(), newValue, this.components());
    }

    public ImmutableWebhookMessageEditRequest withAttachmentsOrNull(@Nullable Iterable<? extends AttachmentData> elements) {
        Possible<Optional<List<AttachmentData>>> newValue = Possible.of(Optional.ofNullable(elements).map(els -> StreamSupport.stream(els.spliterator(), false).collect(Collectors.toList())));
        return new ImmutableWebhookMessageEditRequest(this, this.content(), this.embeds(), this.allowedMentions(), newValue, this.components());
    }

    @SafeVarargs
    public final ImmutableWebhookMessageEditRequest withAttachments(AttachmentData ... elements) {
        Possible<Optional<List<AttachmentData>>> newValue = Possible.of(Optional.of(Arrays.asList(elements)));
        return new ImmutableWebhookMessageEditRequest(this, this.content(), this.embeds(), this.allowedMentions(), newValue, this.components());
    }

    public ImmutableWebhookMessageEditRequest withComponents(Possible<? extends List<? extends ComponentData>> possible) {
        Possible<List<ComponentData>> newValue = Objects.requireNonNull(possible);
        return new ImmutableWebhookMessageEditRequest(this, this.content(), this.embeds(), this.allowedMentions(), this.attachments(), newValue);
    }

    public ImmutableWebhookMessageEditRequest withComponents(Iterable<? extends ComponentData> elements) {
        Possible<List<ComponentData>> newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return new ImmutableWebhookMessageEditRequest(this, this.content(), this.embeds(), this.allowedMentions(), this.attachments(), newValue);
    }

    @SafeVarargs
    public final ImmutableWebhookMessageEditRequest withComponents(ComponentData ... elements) {
        Possible<List<ComponentData>> newValue = Possible.of(Arrays.asList(elements));
        return new ImmutableWebhookMessageEditRequest(this, this.content(), this.embeds(), this.allowedMentions(), this.attachments(), newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableWebhookMessageEditRequest && this.equalTo(0, (ImmutableWebhookMessageEditRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableWebhookMessageEditRequest another) {
        return this.content().equals(another.content()) && Objects.equals(this.embeds_value, another.embeds_value) && this.allowedMentions().equals(another.allowedMentions()) && Objects.equals(this.attachments_value, another.attachments_value) && Objects.equals(this.components_value, another.components_value);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.content().hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.embeds_value);
        h2 += (h2 << 5) + this.allowedMentions().hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.attachments_value);
        h2 += (h2 << 5) + Objects.hashCode(this.components_value);
        return h2;
    }

    public String toString() {
        return "WebhookMessageEditRequest{content=" + this.content().toString() + ", embeds=" + Objects.toString(this.embeds_value) + ", allowedMentions=" + this.allowedMentions().toString() + ", attachments=" + Objects.toString(this.attachments_value) + ", components=" + Objects.toString(this.components_value) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableWebhookMessageEditRequest fromJson(Json json) {
        Builder builder = ImmutableWebhookMessageEditRequest.builder();
        if (json.content != null) {
            builder.content(json.content);
        }
        if (json.embeds != null) {
            builder.embeds(json.embeds);
        }
        if (json.allowedMentions != null) {
            builder.allowedMentions(json.allowedMentions);
        }
        if (json.attachments != null) {
            builder.attachments(json.attachments);
        }
        if (json.components != null) {
            builder.components(json.components);
        }
        return builder.build();
    }

    public static ImmutableWebhookMessageEditRequest of(Possible<Optional<String>> content, Possible<Optional<List<EmbedData>>> embeds, Possible<Optional<AllowedMentionsData>> allowedMentions, Possible<Optional<List<AttachmentData>>> attachments, Possible<List<ComponentData>> components) {
        return new ImmutableWebhookMessageEditRequest(content, embeds, allowedMentions, attachments, components);
    }

    public static ImmutableWebhookMessageEditRequest copyOf(WebhookMessageEditRequest instance) {
        if (instance instanceof ImmutableWebhookMessageEditRequest) {
            return (ImmutableWebhookMessageEditRequest)instance;
        }
        return ImmutableWebhookMessageEditRequest.builder().from(instance).build();
    }

    public boolean isContentPresent() {
        return !this.content_absent;
    }

    public String contentOrElse(String defaultValue) {
        return !this.content_absent ? this.content_value : defaultValue;
    }

    public boolean isEmbedsPresent() {
        return !this.embeds_absent;
    }

    public List<EmbedData> embedsOrElse(List<EmbedData> defaultValue) {
        return !this.embeds_absent ? this.embeds_value : defaultValue;
    }

    public boolean isAllowedMentionsPresent() {
        return !this.allowedMentions_absent;
    }

    public AllowedMentionsData allowedMentionsOrElse(AllowedMentionsData defaultValue) {
        return !this.allowedMentions_absent ? this.allowedMentions_value : defaultValue;
    }

    public boolean isAttachmentsPresent() {
        return !this.attachments_absent;
    }

    public List<AttachmentData> attachmentsOrElse(List<AttachmentData> defaultValue) {
        return !this.attachments_absent ? this.attachments_value : defaultValue;
    }

    public boolean isComponentsPresent() {
        return !this.components_absent;
    }

    public List<ComponentData> componentsOrElse(List<ComponentData> defaultValue) {
        return !this.components_absent ? this.components_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="WebhookMessageEditRequest", generator="Immutables")
    public static final class Builder {
        private Possible<Optional<String>> content_possible = Possible.absent();
        private List<EmbedData> embeds_list = null;
        private boolean embeds_explicitNull;
        private Possible<Optional<AllowedMentionsData>> allowedMentions_possible = Possible.absent();
        private List<AttachmentData> attachments_list = null;
        private boolean attachments_explicitNull;
        private List<ComponentData> components_list = null;

        private Builder() {
        }

        public final Builder from(WebhookMessageEditRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.content(instance.content());
            this.embeds(instance.embeds());
            this.allowedMentions(instance.allowedMentions());
            this.attachments(instance.attachments());
            this.components(instance.components());
            return this;
        }

        @JsonProperty(value="content")
        public Builder content(Possible<Optional<String>> value) {
            this.content_possible = value;
            return this;
        }

        @Deprecated
        public Builder content(@Nullable String value) {
            this.content_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder contentOrNull(@Nullable String value) {
            this.content_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder addEmbed(EmbedData element) {
            this.embeds_getOrCreate().add(element);
            this.embeds_explicitNull = false;
            return this;
        }

        public Builder addAllEmbeds(Collection<? extends EmbedData> elements) {
            this.embeds_getOrCreate().addAll(elements);
            this.embeds_explicitNull = false;
            return this;
        }

        @JsonProperty(value="embeds")
        public Builder embeds(Possible<? extends Optional<? extends Collection<? extends EmbedData>>> elements) {
            this.embeds_list = null;
            this.embeds_explicitNull = false;
            elements.toOptional().ifPresent(e -> {
                if (e.isPresent()) {
                    this.embeds_getOrCreate().addAll((Collection)e.get());
                } else {
                    this.embeds_explicitNull = true;
                }
            });
            return this;
        }

        @Deprecated
        public Builder embeds(@Nullable Iterable<EmbedData> elements) {
            if (elements == null) {
                this.embeds_list = null;
                this.embeds_explicitNull = true;
            } else {
                this.embeds_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
                this.embeds_explicitNull = false;
            }
            return this;
        }

        public Builder embedsOrNull(@Nullable Iterable<? extends EmbedData> elements) {
            if (elements == null) {
                this.embeds_list = null;
                this.embeds_explicitNull = true;
            } else {
                this.embeds_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
                this.embeds_explicitNull = false;
            }
            return this;
        }

        @SafeVarargs
        public final Builder embedsOrNull(EmbedData ... elements) {
            if (elements == null) {
                this.embeds_list = null;
                this.embeds_explicitNull = true;
            } else {
                this.embeds_list = Arrays.asList(elements);
                this.embeds_explicitNull = false;
            }
            return this;
        }

        @JsonProperty(value="allowed_mentions")
        public Builder allowedMentions(Possible<Optional<AllowedMentionsData>> value) {
            this.allowedMentions_possible = value;
            return this;
        }

        @Deprecated
        public Builder allowedMentions(@Nullable AllowedMentionsData value) {
            this.allowedMentions_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder allowedMentionsOrNull(@Nullable AllowedMentionsData value) {
            this.allowedMentions_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder addAttachment(AttachmentData element) {
            this.attachments_getOrCreate().add(element);
            this.attachments_explicitNull = false;
            return this;
        }

        public Builder addAllAttachments(Collection<? extends AttachmentData> elements) {
            this.attachments_getOrCreate().addAll(elements);
            this.attachments_explicitNull = false;
            return this;
        }

        @JsonProperty(value="attachments")
        public Builder attachments(Possible<? extends Optional<? extends Collection<? extends AttachmentData>>> elements) {
            this.attachments_list = null;
            this.attachments_explicitNull = false;
            elements.toOptional().ifPresent(e -> {
                if (e.isPresent()) {
                    this.attachments_getOrCreate().addAll((Collection)e.get());
                } else {
                    this.attachments_explicitNull = true;
                }
            });
            return this;
        }

        @Deprecated
        public Builder attachments(@Nullable Iterable<AttachmentData> elements) {
            if (elements == null) {
                this.attachments_list = null;
                this.attachments_explicitNull = true;
            } else {
                this.attachments_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
                this.attachments_explicitNull = false;
            }
            return this;
        }

        public Builder attachmentsOrNull(@Nullable Iterable<? extends AttachmentData> elements) {
            if (elements == null) {
                this.attachments_list = null;
                this.attachments_explicitNull = true;
            } else {
                this.attachments_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
                this.attachments_explicitNull = false;
            }
            return this;
        }

        @SafeVarargs
        public final Builder attachmentsOrNull(AttachmentData ... elements) {
            if (elements == null) {
                this.attachments_list = null;
                this.attachments_explicitNull = true;
            } else {
                this.attachments_list = Arrays.asList(elements);
                this.attachments_explicitNull = false;
            }
            return this;
        }

        public Builder addComponent(ComponentData element) {
            this.components_getOrCreate().add(element);
            return this;
        }

        public Builder addAllComponents(Collection<? extends ComponentData> elements) {
            this.components_getOrCreate().addAll(elements);
            return this;
        }

        @JsonProperty(value="components")
        public Builder components(Possible<? extends Collection<? extends ComponentData>> elements) {
            this.components_list = null;
            elements.toOptional().ifPresent(e -> this.components_getOrCreate().addAll((Collection<ComponentData>)e));
            return this;
        }

        public Builder components(Iterable<? extends ComponentData> elements) {
            this.components_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
            return this;
        }

        @SafeVarargs
        public final Builder components(ComponentData ... elements) {
            this.components_list = Arrays.asList(elements);
            return this;
        }

        public ImmutableWebhookMessageEditRequest build() {
            return new ImmutableWebhookMessageEditRequest(null, this.content_build(), this.embeds_build(), this.allowedMentions_build(), this.attachments_build(), this.components_build());
        }

        private Possible<Optional<String>> content_build() {
            return this.content_possible;
        }

        private Possible<Optional<List<EmbedData>>> embeds_build() {
            return this.embeds_list == null && !this.embeds_explicitNull ? Possible.absent() : Possible.of(Optional.ofNullable(this.embeds_list));
        }

        private List<EmbedData> embeds_getOrCreate() {
            if (this.embeds_list == null) {
                this.embeds_list = new ArrayList<EmbedData>();
            }
            return this.embeds_list;
        }

        private Possible<Optional<AllowedMentionsData>> allowedMentions_build() {
            return this.allowedMentions_possible;
        }

        private Possible<Optional<List<AttachmentData>>> attachments_build() {
            return this.attachments_list == null && !this.attachments_explicitNull ? Possible.absent() : Possible.of(Optional.ofNullable(this.attachments_list));
        }

        private List<AttachmentData> attachments_getOrCreate() {
            if (this.attachments_list == null) {
                this.attachments_list = new ArrayList<AttachmentData>();
            }
            return this.attachments_list;
        }

        private Possible<List<ComponentData>> components_build() {
            return this.components_list == null ? Possible.absent() : Possible.of(this.components_list);
        }

        private List<ComponentData> components_getOrCreate() {
            if (this.components_list == null) {
                this.components_list = new ArrayList<ComponentData>();
            }
            return this.components_list;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="WebhookMessageEditRequest", generator="Immutables")
    static final class Json
    implements WebhookMessageEditRequest {
        Possible<Optional<String>> content = Possible.absent();
        Possible<Optional<List<EmbedData>>> embeds = Possible.absent();
        Possible<Optional<AllowedMentionsData>> allowedMentions = Possible.absent();
        Possible<Optional<List<AttachmentData>>> attachments = Possible.absent();
        Possible<List<ComponentData>> components = Possible.absent();

        Json() {
        }

        @JsonProperty(value="content")
        public void setContent(Possible<Optional<String>> content) {
            this.content = content;
        }

        @JsonProperty(value="embeds")
        public void setEmbeds(Possible<Optional<List<EmbedData>>> embeds) {
            this.embeds = embeds;
        }

        @JsonProperty(value="allowed_mentions")
        public void setAllowedMentions(Possible<Optional<AllowedMentionsData>> allowedMentions) {
            this.allowedMentions = allowedMentions;
        }

        @JsonProperty(value="attachments")
        public void setAttachments(Possible<Optional<List<AttachmentData>>> attachments) {
            this.attachments = attachments;
        }

        @JsonProperty(value="components")
        public void setComponents(Possible<List<ComponentData>> components) {
            this.components = components;
        }

        @Override
        public Possible<Optional<String>> content() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Optional<List<EmbedData>>> embeds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Optional<AllowedMentionsData>> allowedMentions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Optional<List<AttachmentData>>> attachments() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<List<ComponentData>> components() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="WebhookMessageEditRequest", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build WebhookMessageEditRequest, attribute initializers form cycle " + attributes;
        }
    }
}

