/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.streamserver.mysql;

import com.gmail.berndivader.streamserver.Helper;
import com.gmail.berndivader.streamserver.config.Config;
import com.gmail.berndivader.streamserver.mysql.DatabaseConnection;
import com.gmail.berndivader.streamserver.term.ANSI;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public class AddScheduled
implements Callable<Boolean> {
    private static final String SQL_INSERT = "INSERT INTO `scheduled` (`title`, `filename`) VALUES(?, ?);";
    private static final String SQL_TESTFOR = "SELECT `filename` from `scheduled` where `filename` = ?";
    private String title;
    private String filename;
    public Future<Boolean> future;

    public AddScheduled(String filename) {
        this.title = filename.substring(0, filename.length() - 4);
        this.filename = filename;
        this.future = Helper.EXECUTOR.submit(this);
    }

    @Override
    public Boolean call() {
        boolean exists;
        block24: {
            exists = false;
            try (Connection connection = DatabaseConnection.getNewConnection();){
                connection.setAutoCommit(false);
                try (PreparedStatement testfor = connection.prepareStatement(SQL_TESTFOR, 1004, 1007);){
                    testfor.setString(1, this.filename);
                    ResultSet result = testfor.executeQuery();
                    result.last();
                    exists = result.getRow() > 0;
                }
                if (exists) break block24;
                try (PreparedStatement insert = connection.prepareStatement(SQL_INSERT, 1005, 1007);){
                    insert.setString(1, this.title);
                    insert.setString(2, this.filename);
                    insert.execute();
                    connection.commit();
                }
                catch (SQLException e) {
                    connection.rollback();
                    throw e;
                }
            }
            catch (SQLException e) {
                ANSI.printErr("Failed to add a file to the scheduled playlist", e);
                return false;
            }
        }
        if (Config.DEBUG.booleanValue()) {
            ANSI.println(exists ? "\n[MYSQL TRACK ADDED FOR SCHEDULE]" : "\n[MYSQL TRACK ALREADY ON SCHEDULE]");
        }
        return !exists;
    }
}

