/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import reactor.netty.resources.ConnectionProvider;

public final class Http2AllocationStrategy
implements ConnectionProvider.AllocationStrategy<Http2AllocationStrategy> {
    final long maxConcurrentStreams;
    final int maxConnections;
    final int minConnections;
    volatile int permits;
    static final AtomicIntegerFieldUpdater<Http2AllocationStrategy> PERMITS = AtomicIntegerFieldUpdater.newUpdater(Http2AllocationStrategy.class, "permits");

    public static Builder builder() {
        return new Build();
    }

    @Override
    public Http2AllocationStrategy copy() {
        return new Http2AllocationStrategy(this);
    }

    @Override
    public int estimatePermitCount() {
        return PERMITS.get(this);
    }

    @Override
    public int getPermits(int desired) {
        int target;
        int p;
        if (desired < 0) {
            return 0;
        }
        while (!PERMITS.compareAndSet(this, p = this.permits, p - (target = Math.min(desired, p)))) {
        }
        return target;
    }

    public long maxConcurrentStreams() {
        return this.maxConcurrentStreams;
    }

    @Override
    public int permitGranted() {
        return this.maxConnections - PERMITS.get(this);
    }

    @Override
    public int permitMinimum() {
        return this.minConnections;
    }

    @Override
    public int permitMaximum() {
        return this.maxConnections;
    }

    @Override
    public void returnPermits(int returned) {
        int p;
        do {
            if ((p = PERMITS.get(this)) + returned <= this.maxConnections) continue;
            throw new IllegalArgumentException("Too many permits returned: returned=" + returned + ", would bring to " + (p + returned) + "/" + this.maxConnections);
        } while (!PERMITS.compareAndSet(this, p, p + returned));
    }

    Http2AllocationStrategy(Build build) {
        this.maxConcurrentStreams = build.maxConcurrentStreams;
        this.maxConnections = build.maxConnections;
        this.minConnections = build.minConnections;
        PERMITS.lazySet(this, this.maxConnections);
    }

    Http2AllocationStrategy(Http2AllocationStrategy copy) {
        this.maxConcurrentStreams = copy.maxConcurrentStreams;
        this.maxConnections = copy.maxConnections;
        this.minConnections = copy.minConnections;
        PERMITS.lazySet(this, this.maxConnections);
    }

    static final class Build
    implements Builder {
        static final long DEFAULT_MAX_CONCURRENT_STREAMS = -1L;
        static final int DEFAULT_MAX_CONNECTIONS = Integer.MAX_VALUE;
        static final int DEFAULT_MIN_CONNECTIONS = 0;
        long maxConcurrentStreams = -1L;
        int maxConnections = Integer.MAX_VALUE;
        int minConnections = 0;

        Build() {
        }

        @Override
        public Http2AllocationStrategy build() {
            if (this.minConnections > this.maxConnections) {
                throw new IllegalArgumentException("minConnections (" + this.minConnections + ") must be less than or equal to maxConnections (" + this.maxConnections + ")");
            }
            return new Http2AllocationStrategy(this);
        }

        @Override
        public Builder maxConcurrentStreams(long maxConcurrentStreams) {
            if (maxConcurrentStreams < -1L) {
                throw new IllegalArgumentException("maxConcurrentStreams must be greater than or equal to -1");
            }
            this.maxConcurrentStreams = maxConcurrentStreams;
            return this;
        }

        @Override
        public Builder maxConnections(int maxConnections) {
            if (maxConnections < 1) {
                throw new IllegalArgumentException("maxConnections must be strictly positive");
            }
            this.maxConnections = maxConnections;
            return this;
        }

        @Override
        public Builder minConnections(int minConnections) {
            if (minConnections < 0) {
                throw new IllegalArgumentException("minConnections must be positive or zero");
            }
            this.minConnections = minConnections;
            return this;
        }
    }

    public static interface Builder {
        public Http2AllocationStrategy build();

        public Builder maxConcurrentStreams(long var1);

        public Builder maxConnections(int var1);

        public Builder minConnections(int var1);
    }
}

