/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.streamserver.mysql;

import com.github.kokorin.jaffree.ffprobe.FFprobe;
import com.github.kokorin.jaffree.ffprobe.FFprobeResult;
import com.gmail.berndivader.streamserver.Helper;
import com.gmail.berndivader.streamserver.ffmpeg.BroadcastRunner;
import com.gmail.berndivader.streamserver.ffmpeg.FFProbePacket;
import com.gmail.berndivader.streamserver.mysql.DatabaseConnection;
import com.gmail.berndivader.streamserver.term.ANSI;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class UpdatePlaylist
implements Callable<Boolean> {
    static final String SQL = "INSERT INTO `playlist` (`title`, `filepath`, `ffprobe`) VALUES(?, ?, ?);";
    static final String[] SPINNER = new String[]{"\b/", "\b-", "\b\\", "\b|"};
    final boolean IS_COMMAND;

    public UpdatePlaylist(boolean fromConsole) throws InterruptedException, ExecutionException, TimeoutException {
        Future<Boolean> future = Helper.EXECUTOR.submit(this);
        this.IS_COMMAND = fromConsole;
        if (this.IS_COMMAND) {
            if (future.get(20L, TimeUnit.MINUTES).booleanValue()) {
                ANSI.println("[BR][SUCESSFUL MYSQL PLAYLIST UPDATE]");
            } else {
                ANSI.warn("[BR][FAILED MYSQL PLAYLIST UPDATE]");
            }
        }
    }

    static FFprobeResult getFFprobeResult(String path) {
        return FFprobe.atPath().setInput(path).setShowFormat(true).execute();
    }

    @Override
    public Boolean call() throws Exception {
        BroadcastRunner.refreshFilelist();
        File[] files = (File[])BroadcastRunner.getFiles().clone();
        try (Connection connection = DatabaseConnection.getNewConnection();){
            connection.setAutoCommit(false);
            try (PreparedStatement statement = connection.prepareStatement(SQL, 1004, 1007);){
                ANSI.println("[BEGIN MYSQL PLAYLIST UPDATE]");
                if (this.IS_COMMAND) {
                    ANSI.print("[GREEN]|");
                }
                statement.addBatch("START TRANSACTION;");
                statement.addBatch("TRUNCATE TABLE playlist;");
                for (int i1 = 0; i1 < files.length; ++i1) {
                    if (this.IS_COMMAND) {
                        ANSI.print(SPINNER[i1 % SPINNER.length]);
                    }
                    FFProbePacket packet = FFProbePacket.build(files[i1]);
                    String path = packet.getPath();
                    String title = packet.tags.title;
                    String comment = packet.toString();
                    statement.setString(1, title);
                    statement.setString(2, path);
                    statement.setString(3, comment);
                    statement.addBatch();
                }
                statement.addBatch("COMMIT;");
                statement.executeBatch();
            }
            catch (SQLException e) {
                connection.rollback();
                throw e;
            }
        }
        catch (Exception e) {
            ANSI.error("Update playlist failed.", e);
            return false;
        }
        return true;
    }
}

