/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.container.common;

import com.sedmelluq.discord.lavaplayer.filter.AudioPipeline;
import com.sedmelluq.discord.lavaplayer.filter.AudioPipelineFactory;
import com.sedmelluq.discord.lavaplayer.filter.PcmFormat;
import com.sedmelluq.discord.lavaplayer.natives.aac.AacDecoder;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioProcessingContext;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AacPacketRouter {
    private static final Logger log = LoggerFactory.getLogger(AacPacketRouter.class);
    private final AudioProcessingContext context;
    private final Consumer<AacDecoder> decoderConfigurer;
    private Long initialRequestedTimecode;
    private Long initialProvidedTimecode;
    private ShortBuffer outputBuffer;
    private AudioPipeline downstream;
    public AacDecoder decoder;

    public AacPacketRouter(AudioProcessingContext context, Consumer<AacDecoder> decoderConfigurer) {
        this.context = context;
        this.decoderConfigurer = decoderConfigurer;
    }

    public void processInput(ByteBuffer inputBuffer) throws InterruptedException {
        AacDecoder.StreamInfo streamInfo;
        if (this.decoder == null) {
            this.decoder = new AacDecoder();
            this.decoderConfigurer.accept(this.decoder);
        }
        this.decoder.fill(inputBuffer);
        if (this.downstream == null && (streamInfo = this.decoder.resolveStreamInfo()) != null) {
            this.downstream = AudioPipelineFactory.create(this.context, new PcmFormat(streamInfo.channels, streamInfo.sampleRate));
            this.outputBuffer = ByteBuffer.allocateDirect(2 * streamInfo.frameSize * streamInfo.channels).order(ByteOrder.nativeOrder()).asShortBuffer();
            if (this.initialRequestedTimecode != null) {
                this.downstream.seekPerformed(this.initialRequestedTimecode, this.initialProvidedTimecode);
            }
        }
        if (this.downstream != null) {
            while (this.decoder.decode(this.outputBuffer, false)) {
                this.downstream.process(this.outputBuffer);
                this.outputBuffer.clear();
            }
        }
    }

    public void seekPerformed(long requestedTimecode, long providedTimecode) {
        if (this.downstream != null) {
            this.downstream.seekPerformed(requestedTimecode, providedTimecode);
        } else {
            this.initialRequestedTimecode = requestedTimecode;
            this.initialProvidedTimecode = providedTimecode;
        }
        if (this.decoder != null) {
            this.decoder.close();
            this.decoder = null;
        }
    }

    public void flush() throws InterruptedException {
        if (this.downstream != null) {
            while (this.decoder.decode(this.outputBuffer, true)) {
                this.downstream.process(this.outputBuffer);
                this.outputBuffer.clear();
            }
        }
    }

    public void close() {
        try {
            if (this.downstream != null) {
                this.downstream.close();
            }
        }
        finally {
            if (this.decoder != null) {
                this.decoder.close();
            }
        }
    }
}

