/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.automod;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.DiscordObject;
import discord4j.discordjson.json.AutoModActionData;
import discord4j.discordjson.json.AutoModActionMetaData;
import java.util.Objects;
import java.util.Optional;

public class AutoModRuleAction
implements DiscordObject {
    private final GatewayDiscordClient gateway;
    private final AutoModActionData data;

    public AutoModRuleAction(GatewayDiscordClient gateway, AutoModActionData data) {
        this.gateway = Objects.requireNonNull(gateway);
        this.data = Objects.requireNonNull(data);
    }

    public AutoModActionData getData() {
        return this.data;
    }

    public Type getType() {
        return Type.of(this.data.type());
    }

    public Optional<AutoModRuleActionMetaData> getMetadata() {
        return this.data.metadata().toOptional().map(data -> new AutoModRuleActionMetaData(this.gateway, (AutoModActionMetaData)data));
    }

    @Override
    public GatewayDiscordClient getClient() {
        return this.gateway;
    }

    public static enum Type {
        UNKNOWN(-1),
        BLOCK_MESSAGE(1),
        SEND_ALERT_MESSAGE(2),
        TIMEOUT(3);

        private final int value;

        private Type(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Type of(int value) {
            for (Type type : Type.values()) {
                if (type.getValue() != value) continue;
                return type;
            }
            return UNKNOWN;
        }
    }

    public static class AutoModRuleActionMetaData
    implements DiscordObject {
        private final GatewayDiscordClient gateway;
        private final AutoModActionMetaData data;

        public AutoModRuleActionMetaData(GatewayDiscordClient gateway, AutoModActionMetaData data) {
            this.gateway = Objects.requireNonNull(gateway);
            this.data = Objects.requireNonNull(data);
        }

        public Optional<Snowflake> getChannelId() {
            return this.data.channelId().toOptional().map(Snowflake::of);
        }

        public Optional<Integer> getDurationTimeout() {
            return this.data.duration().toOptional();
        }

        public Optional<String> getCustomMessage() {
            return this.data.customMessage().toOptional();
        }

        @Override
        public GatewayDiscordClient getClient() {
            return this.gateway;
        }
    }
}

