/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.natives.aac;

import com.sedmelluq.discord.lavaplayer.natives.aac.AacDecoderLibrary;
import com.sedmelluq.discord.lavaplayer.tools.io.BitStreamWriter;
import com.sedmelluq.discord.lavaplayer.tools.io.ByteBufferOutputStream;
import com.sedmelluq.lava.common.natives.NativeResourceHolder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;

public class AacDecoder
extends NativeResourceHolder {
    private static final int[] SAMPLERATE_TABLE = new int[]{96000, 88200, 64000, 48000, 44100, 32000, 24000, 22050, 16000, 12000, 11025, 8000, 7350};
    private static final int TRANSPORT_NONE = 0;
    public static final int AAC_LC = 2;
    public static final int SBR = 5;
    public static final int PS = 29;
    private static final ShortBuffer NO_BUFFER = ByteBuffer.allocateDirect(0).asShortBuffer();
    private static final int ERROR_NOT_ENOUGH_BITS = 4098;
    private static final int ERROR_OUTPUT_BUFFER_TOO_SMALL = 8204;
    private final AacDecoderLibrary library = AacDecoderLibrary.getInstance();
    private final long instance = this.library.create(0);

    public int configure(int objectType, int frequency, int channels) {
        int extensionFrequency = AacDecoder.isSbrOrPs(objectType) ? frequency * 2 : frequency;
        int extensionProfile = AacDecoder.isSbrOrPs(objectType) ? 2 : objectType;
        byte[] buffer = AacDecoder.encodeConfiguration(objectType, frequency, channels, extensionFrequency, extensionProfile);
        return this.configure(buffer);
    }

    public int configure(byte[] config) {
        this.checkNotReleased();
        if (config.length > 8) {
            throw new IllegalArgumentException("Cannot process a header larger than size 8");
        }
        return this.library.configure(this.instance, config);
    }

    private static boolean isSbrOrPs(int objectType) {
        return objectType == 5 || objectType == 29;
    }

    private static byte[] encodeConfiguration(int objectType, int frequency, int channels, int extensionFrequency, int extensionProfile) {
        try {
            ByteBuffer buffer = ByteBuffer.allocate(8);
            buffer.order(ByteOrder.nativeOrder());
            BitStreamWriter bitWriter = new BitStreamWriter(new ByteBufferOutputStream(buffer));
            bitWriter.write(objectType, 5);
            int frequencyIndex = AacDecoder.getFrequencyIndex(frequency);
            bitWriter.write(frequencyIndex, 4);
            if (frequencyIndex == 15) {
                bitWriter.write(frequency, 24);
            }
            bitWriter.write(channels, 4);
            if (AacDecoder.isSbrOrPs(objectType)) {
                int extensionFrequencyIndex = AacDecoder.getFrequencyIndex(extensionFrequency);
                bitWriter.write(extensionFrequencyIndex, 4);
                if (extensionFrequencyIndex == 15) {
                    bitWriter.write(extensionFrequency, 24);
                }
                bitWriter.write(extensionProfile, 5);
            }
            bitWriter.flush();
            buffer.clear();
            return buffer.array();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static int getFrequencyIndex(int frequency) {
        for (int i = 0; i < SAMPLERATE_TABLE.length; ++i) {
            if (SAMPLERATE_TABLE[i] != frequency) continue;
            return i;
        }
        return 15;
    }

    public synchronized int fill(ByteBuffer buffer) {
        this.checkNotReleased();
        if (!buffer.isDirect()) {
            throw new IllegalArgumentException("Buffer argument must be a direct buffer.");
        }
        int readBytes = this.library.fill(this.instance, buffer, buffer.position(), buffer.limit());
        if (readBytes < 0) {
            throw new IllegalStateException("Filling decoder failed with error " + -readBytes);
        }
        buffer.position(buffer.position() + readBytes);
        return readBytes;
    }

    public synchronized boolean decode(ShortBuffer buffer, boolean flush) {
        this.checkNotReleased();
        if (!buffer.isDirect()) {
            throw new IllegalArgumentException("Buffer argument must be a direct buffer.");
        }
        int result = this.library.decode(this.instance, buffer, buffer.capacity(), flush);
        if (result != 0 && result != 4098) {
            throw new IllegalStateException("Error from decoder " + result);
        }
        return result == 0;
    }

    public synchronized StreamInfo resolveStreamInfo() {
        this.checkNotReleased();
        int result = this.library.decode(this.instance, NO_BUFFER, 0, false);
        if (result == 4098) {
            return null;
        }
        if (result != 8204) {
            throw new IllegalStateException("Expected decoding to halt, got: " + result);
        }
        long combinedValue = this.library.getStreamInfo(this.instance);
        if (combinedValue == 0L) {
            throw new IllegalStateException("Native library failed to detect stream info.");
        }
        return new StreamInfo((int)(combinedValue >>> 32), (int)(combinedValue & 0xFFFFL), (int)(combinedValue >>> 16 & 0xFFFFL));
    }

    @Override
    protected void freeResources() {
        this.library.destroy(this.instance);
    }

    public static class StreamInfo {
        public final int sampleRate;
        public final int channels;
        public final int frameSize;

        public StreamInfo(int sampleRate, int channels, int frameSize) {
            this.sampleRate = sampleRate;
            this.channels = channels;
            this.frameSize = frameSize;
        }
    }
}

