/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.youtube;

import com.sedmelluq.discord.lavaplayer.container.matroska.MatroskaAudioTrack;
import com.sedmelluq.discord.lavaplayer.container.mpeg.MpegAudioTrack;
import com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeClientConfig;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeFormatInfo;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeMpegStreamAudioTrack;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubePersistentHttpStream;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeTrackDetails;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeTrackFormat;
import com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.DelegatedAudioTrack;
import com.sedmelluq.discord.lavaplayer.track.playback.LocalAudioTrackExecutor;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YoutubeAudioTrack
extends DelegatedAudioTrack {
    private static final Logger log = LoggerFactory.getLogger(YoutubeAudioTrack.class);
    private final YoutubeAudioSourceManager sourceManager;

    public YoutubeAudioTrack(AudioTrackInfo trackInfo, YoutubeAudioSourceManager sourceManager) {
        super(trackInfo);
        this.sourceManager = sourceManager;
    }

    @Override
    public void process(LocalAudioTrackExecutor localExecutor) throws Exception {
        FormatWithUrl format = this.loadBestFormatWithUrl(null);
        log.debug("Starting track from URL: {}", (Object)format.signedUrl);
        if (this.trackInfo.isStream || format.details.getContentLength() == Long.MAX_VALUE) {
            this.processStream(localExecutor, format);
        } else {
            try {
                this.processStatic(localExecutor, format);
            }
            catch (RuntimeException e) {
                String message = e.getMessage();
                if (!"Not success status code: 403".equals(message) && !"Invalid status code for video page response: 400".equals(message)) {
                    throw e;
                }
                String code = message.split(": ", 2)[1];
                log.warn("Encountered {} when requesting formats with default client, re-requesting with WEB client.", (Object)code);
                YoutubeClientConfig fallbackConfig = YoutubeClientConfig.WEB.copy().withRootField("params", "ygUEbmF0dA%3D%3D");
                this.processStatic(localExecutor, this.loadBestFormatWithUrl(fallbackConfig));
            }
        }
    }

    private void processStatic(LocalAudioTrackExecutor localExecutor, FormatWithUrl format) throws Exception {
        try (HttpInterface httpInterface = this.sourceManager.getHttpInterface();
             YoutubePersistentHttpStream stream = new YoutubePersistentHttpStream(httpInterface, format.signedUrl, format.details.getContentLength());){
            if (format.details.getType().getMimeType().endsWith("/webm")) {
                this.processDelegate(new MatroskaAudioTrack(this.trackInfo, stream), localExecutor);
            } else {
                this.processDelegate(new MpegAudioTrack(this.trackInfo, stream), localExecutor);
            }
        }
    }

    private void processStream(LocalAudioTrackExecutor localExecutor, FormatWithUrl format) throws Exception {
        if ("audio/webm".equals(format.details.getType().getMimeType())) {
            throw new FriendlyException("YouTube WebM streams are currently not supported.", FriendlyException.Severity.COMMON, null);
        }
        try (HttpInterface streamingInterface = this.sourceManager.getHttpInterface();){
            this.processDelegate(new YoutubeMpegStreamAudioTrack(this.trackInfo, streamingInterface, format.signedUrl), localExecutor);
        }
    }

    private FormatWithUrl loadBestFormatWithUrl(YoutubeClientConfig config) throws Exception {
        try (HttpInterface httpInterface = this.sourceManager.getHttpInterface();){
            YoutubeTrackDetails details = this.sourceManager.getTrackDetailsLoader().loadDetails(httpInterface, this.getIdentifier(), true, this.sourceManager, config);
            if (details == null) {
                throw new FriendlyException("This video is not available", FriendlyException.Severity.COMMON, null);
            }
            List<YoutubeTrackFormat> formats = details.getFormats(httpInterface, this.sourceManager.getSignatureResolver());
            YoutubeTrackFormat format = YoutubeAudioTrack.findBestSupportedFormat(formats);
            URI signedUrl = this.sourceManager.getSignatureResolver().resolveFormatUrl(httpInterface, details.getPlayerScript(), format);
            FormatWithUrl formatWithUrl = new FormatWithUrl(format, signedUrl, details.getPlayerScript());
            return formatWithUrl;
        }
    }

    @Override
    protected AudioTrack makeShallowClone() {
        return new YoutubeAudioTrack(this.trackInfo, this.sourceManager);
    }

    @Override
    public AudioSourceManager getSourceManager() {
        return this.sourceManager;
    }

    @Override
    public boolean isSeekable() {
        return true;
    }

    private static boolean isBetterFormat(YoutubeTrackFormat format, YoutubeTrackFormat other) {
        YoutubeFormatInfo info = format.getInfo();
        if (info == null) {
            return false;
        }
        if (other == null) {
            return true;
        }
        if ("audio/webm".equals(info.mimeType) && format.getAudioChannels() > 2L) {
            return false;
        }
        if (info.ordinal() != other.getInfo().ordinal()) {
            return info.ordinal() < other.getInfo().ordinal();
        }
        return format.getBitrate() > other.getBitrate();
    }

    private static YoutubeTrackFormat findBestSupportedFormat(List<YoutubeTrackFormat> formats) {
        YoutubeTrackFormat bestFormat = null;
        for (YoutubeTrackFormat format2 : formats) {
            if (!format2.isDefaultAudioTrack() || !YoutubeAudioTrack.isBetterFormat(format2, bestFormat)) continue;
            bestFormat = format2;
        }
        if (bestFormat == null) {
            StringJoiner joiner = new StringJoiner(", ");
            formats.forEach(format -> joiner.add(format.getType().toString()));
            throw new IllegalStateException("No supported audio streams available, available types: " + joiner);
        }
        return bestFormat;
    }

    private static class FormatWithUrl {
        private final YoutubeTrackFormat details;
        private final URI signedUrl;
        private final String playerScriptUrl;

        private FormatWithUrl(YoutubeTrackFormat details, URI signedUrl, String playerScriptUrl) {
            this.details = details;
            this.signedUrl = signedUrl;
            this.playerScriptUrl = playerScriptUrl;
        }

        public FormatWithUrl getFallback() {
            String signedUrl = this.signedUrl.toString();
            Map<String, String> urlParameters = DataFormatTools.decodeUrlEncodedItems(signedUrl, false);
            String mn = urlParameters.get("mn");
            if (mn == null) {
                return null;
            }
            CharSequence[] hosts = mn.split(",");
            if (hosts.length < 2) {
                log.warn("Cannot fallback, available hosts: {}", (Object)String.join((CharSequence)", ", hosts));
                return null;
            }
            String newUrl = signedUrl.replaceFirst(hosts[0], (String)hosts[1]);
            try {
                URI uri = new URI(newUrl);
                return new FormatWithUrl(this.details, uri, this.playerScriptUrl);
            }
            catch (URISyntaxException e) {
                return null;
            }
        }
    }
}

