/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core;

import java.net.URI;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.glassfish.tyrus.core.TyrusConfiguration;
import org.glassfish.tyrus.spi.UpgradeRequest;

public final class RequestContext
extends UpgradeRequest {
    private final URI requestURI;
    private final String queryString;
    private final Object httpSession;
    private final boolean secure;
    private final Principal userPrincipal;
    private final Builder.IsUserInRoleDelegate isUserInRoleDelegate;
    private final String remoteAddr;
    private final String serverAddr;
    private final int serverPort;
    private final TyrusConfiguration tyrusConfiguration;
    private Map<String, List<String>> headers;
    private Map<String, List<String>> parameterMap;

    private RequestContext(URI requestURI, String queryString, Object httpSession, boolean secure, Principal userPrincipal, Builder.IsUserInRoleDelegate IsUserInRoleDelegate2, String remoteAddr, String serverAddr, int serverPort, Map<String, List<String>> parameterMap, Map<String, List<String>> headers, Map<String, Object> tyrusProperties) {
        this.requestURI = requestURI;
        this.queryString = queryString;
        this.httpSession = httpSession;
        this.secure = secure;
        this.userPrincipal = userPrincipal;
        this.isUserInRoleDelegate = IsUserInRoleDelegate2;
        this.remoteAddr = remoteAddr;
        this.serverAddr = serverAddr;
        this.serverPort = serverPort;
        this.parameterMap = parameterMap;
        this.headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        this.tyrusConfiguration = new TyrusConfiguration.Builder().tyrusProperties(tyrusProperties).build();
        if (headers != null) {
            this.headers.putAll(headers);
        }
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    @Override
    public String getHeader(String name) {
        List<String> stringList = this.headers.get(name);
        if (stringList == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String s2 : stringList) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(s2);
        }
        return sb.toString();
    }

    public void lock() {
        this.headers = Collections.unmodifiableMap(this.headers);
        this.parameterMap = Collections.unmodifiableMap(this.parameterMap);
    }

    @Override
    public Principal getUserPrincipal() {
        return this.userPrincipal;
    }

    @Override
    public URI getRequestURI() {
        return this.requestURI;
    }

    @Override
    public boolean isUserInRole(String role) {
        if (this.isUserInRoleDelegate != null) {
            return this.isUserInRoleDelegate.isUserInRole(role);
        }
        return false;
    }

    @Override
    public Object getHttpSession() {
        return this.httpSession;
    }

    @Override
    public Map<String, List<String>> getParameterMap() {
        return this.parameterMap;
    }

    @Override
    public String getQueryString() {
        return this.queryString;
    }

    @Override
    public String getRequestUri() {
        return this.requestURI.toString();
    }

    @Override
    public boolean isSecure() {
        return this.secure;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public String getServerAddr() {
        return this.serverAddr;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    TyrusConfiguration getTyrusConfiguration() {
        return this.tyrusConfiguration;
    }

    public static final class Builder {
        private URI requestURI;
        private String queryString;
        private Object httpSession;
        private boolean secure;
        private Principal userPrincipal;
        private IsUserInRoleDelegate isUserInRoleDelegate;
        private Map<String, List<String>> parameterMap;
        private String remoteAddr;
        private String serverAddr;
        private int serverPort;
        private Map<String, List<String>> headers;
        private Map<String, Object> tyrusProperties;

        public static Builder create() {
            return new Builder();
        }

        public static Builder create(RequestContext requestContext) {
            Builder builder = new Builder();
            builder.requestURI = requestContext.requestURI;
            builder.queryString = requestContext.queryString;
            builder.httpSession = requestContext.httpSession;
            builder.secure = requestContext.secure;
            builder.userPrincipal = requestContext.userPrincipal;
            builder.isUserInRoleDelegate = requestContext.isUserInRoleDelegate;
            builder.parameterMap = requestContext.parameterMap;
            builder.remoteAddr = requestContext.remoteAddr;
            builder.serverAddr = requestContext.serverAddr;
            builder.serverPort = requestContext.serverPort;
            builder.headers = requestContext.headers;
            builder.tyrusProperties = requestContext.tyrusConfiguration.tyrusProperties();
            return builder;
        }

        public Builder requestURI(URI requestURI) {
            this.requestURI = requestURI;
            return this;
        }

        public Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public Builder httpSession(Object httpSession) {
            this.httpSession = httpSession;
            return this;
        }

        public Builder secure(boolean secure) {
            this.secure = secure;
            return this;
        }

        public Builder userPrincipal(Principal principal) {
            this.userPrincipal = principal;
            return this;
        }

        public Builder isUserInRoleDelegate(IsUserInRoleDelegate isUserInRoleDelegate) {
            this.isUserInRoleDelegate = isUserInRoleDelegate;
            return this;
        }

        public Builder parameterMap(Map<String, String[]> parameterMap) {
            if (parameterMap != null) {
                this.parameterMap = new HashMap<String, List<String>>();
                for (Map.Entry<String, String[]> entry : parameterMap.entrySet()) {
                    this.parameterMap.put(entry.getKey(), Arrays.asList(entry.getValue()));
                }
            } else {
                this.parameterMap = null;
            }
            return this;
        }

        public Builder remoteAddr(String remoteAddr) {
            this.remoteAddr = remoteAddr;
            return this;
        }

        public Builder serverAddr(String serverAddr) {
            this.serverAddr = serverAddr;
            return this;
        }

        public Builder serverPort(int serverPort) {
            this.serverPort = serverPort;
            return this;
        }

        public Builder tyrusProperties(Map<String, Object> tyrusProperties) {
            this.tyrusProperties = tyrusProperties;
            return this;
        }

        public RequestContext build() {
            return new RequestContext(this.requestURI, this.queryString, this.httpSession, this.secure, this.userPrincipal, this.isUserInRoleDelegate, this.remoteAddr, this.serverAddr, this.serverPort, this.parameterMap != null ? this.parameterMap : new HashMap<String, List<String>>(), this.headers, this.tyrusProperties);
        }

        public static interface IsUserInRoleDelegate {
            public boolean isUserInRole(String var1);
        }
    }
}

