/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.EmojiData;
import discord4j.discordjson.json.ReactionData;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="ReactionData", generator="Immutables")
public final class ImmutableReactionData
implements ReactionData {
    private final int count;
    private final boolean me;
    private final EmojiData emoji;

    private ImmutableReactionData(int count, boolean me, EmojiData emoji) {
        this.count = count;
        this.me = me;
        this.emoji = Objects.requireNonNull(emoji, "emoji");
    }

    private ImmutableReactionData(ImmutableReactionData original, int count, boolean me, EmojiData emoji) {
        this.count = count;
        this.me = me;
        this.emoji = emoji;
    }

    @Override
    @JsonProperty(value="count")
    public int count() {
        return this.count;
    }

    @Override
    @JsonProperty(value="me")
    public boolean me() {
        return this.me;
    }

    @Override
    @JsonProperty(value="emoji")
    public EmojiData emoji() {
        return this.emoji;
    }

    public final ImmutableReactionData withCount(int value) {
        if (this.count == value) {
            return this;
        }
        return new ImmutableReactionData(this, value, this.me, this.emoji);
    }

    public final ImmutableReactionData withMe(boolean value) {
        if (this.me == value) {
            return this;
        }
        return new ImmutableReactionData(this, this.count, value, this.emoji);
    }

    public final ImmutableReactionData withEmoji(EmojiData value) {
        if (this.emoji == value) {
            return this;
        }
        EmojiData newValue = Objects.requireNonNull(value, "emoji");
        return new ImmutableReactionData(this, this.count, this.me, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableReactionData && this.equalTo(0, (ImmutableReactionData)another);
    }

    private boolean equalTo(int synthetic, ImmutableReactionData another) {
        return this.count == another.count && this.me == another.me && this.emoji.equals(another.emoji);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.count;
        h2 += (h2 << 5) + Boolean.hashCode(this.me);
        h2 += (h2 << 5) + this.emoji.hashCode();
        return h2;
    }

    public String toString() {
        return "ReactionData{count=" + this.count + ", me=" + this.me + ", emoji=" + this.emoji + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableReactionData fromJson(Json json) {
        Builder builder = ImmutableReactionData.builder();
        if (json.countIsSet) {
            builder.count(json.count);
        }
        if (json.meIsSet) {
            builder.me(json.me);
        }
        if (json.emoji != null) {
            builder.emoji(json.emoji);
        }
        return builder.build();
    }

    public static ImmutableReactionData of(int count, boolean me, EmojiData emoji) {
        return new ImmutableReactionData(count, me, emoji);
    }

    public static ImmutableReactionData copyOf(ReactionData instance) {
        if (instance instanceof ImmutableReactionData) {
            return (ImmutableReactionData)instance;
        }
        return ImmutableReactionData.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ReactionData", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_COUNT = 1L;
        private static final long INIT_BIT_ME = 2L;
        private static final long INIT_BIT_EMOJI = 4L;
        private long initBits = 7L;
        private int count;
        private boolean me;
        private EmojiData emoji;

        private Builder() {
        }

        public final Builder from(ReactionData instance) {
            Objects.requireNonNull(instance, "instance");
            this.count(instance.count());
            this.me(instance.me());
            this.emoji(instance.emoji());
            return this;
        }

        @JsonProperty(value="count")
        public final Builder count(int count) {
            this.count = count;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="me")
        public final Builder me(boolean me) {
            this.me = me;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="emoji")
        public final Builder emoji(EmojiData emoji) {
            this.emoji = Objects.requireNonNull(emoji, "emoji");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableReactionData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableReactionData(null, this.count, this.me, this.emoji);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("count");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("me");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("emoji");
            }
            return "Cannot build ReactionData, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ReactionData", generator="Immutables")
    static final class Json
    implements ReactionData {
        int count;
        boolean countIsSet;
        boolean me;
        boolean meIsSet;
        EmojiData emoji;

        Json() {
        }

        @JsonProperty(value="count")
        public void setCount(int count) {
            this.count = count;
            this.countIsSet = true;
        }

        @JsonProperty(value="me")
        public void setMe(boolean me) {
            this.me = me;
            this.meIsSet = true;
        }

        @JsonProperty(value="emoji")
        public void setEmoji(EmojiData emoji) {
            this.emoji = emoji;
        }

        @Override
        public int count() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean me() {
            throw new UnsupportedOperationException();
        }

        @Override
        public EmojiData emoji() {
            throw new UnsupportedOperationException();
        }
    }
}

