/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.streamserver.websocket;

import com.gmail.berndivader.streamserver.Helper;
import com.gmail.berndivader.streamserver.config.Config;
import com.gmail.berndivader.streamserver.ffmpeg.InfoPacket;
import com.gmail.berndivader.streamserver.mysql.MakeDownloadable;
import com.gmail.berndivader.streamserver.term.ANSI;
import jakarta.websocket.CloseReason;
import jakarta.websocket.OnClose;
import jakarta.websocket.OnError;
import jakarta.websocket.OnMessage;
import jakarta.websocket.OnOpen;
import jakarta.websocket.Session;
import jakarta.websocket.server.ServerEndpoint;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

@ServerEndpoint(value="/dl")
public class EndPoint {
    private Session session;
    private boolean flowRunning = false;

    @OnOpen
    public void onOpen(Session session) {
        this.session = session;
        ANSI.info(session.getRequestURI().toASCIIString());
        ANSI.info("WebSocket client connected.");
        ANSI.prompt();
        Helper.EXECUTOR.submit(new PingRunner());
    }

    @OnMessage
    public void onMessage(String content) throws IOException {
        if (this.flowRunning) {
            return;
        }
        if (Helper.isUrl(content)) {
            this.flowRunning = true;
            this.session.getBasicRemote().sendText(PACKET.ACCEPT.value);
            this.download(content);
        }
        this.session.close();
    }

    @OnError
    public void onError(Throwable throwable) throws IOException {
        ANSI.error("WebSocket created an error: ", throwable);
        ANSI.prompt();
        this.session.close(new CloseReason(CloseReason.CloseCodes.PROTOCOL_ERROR, "WebSocket Error."));
    }

    @OnClose
    public void onClose(CloseReason reson) {
        ANSI.info(String.format("WS-CLIENT connection closed. Code: %d, Reason: %s", reson.getCloseCode().getCode(), reson.getReasonPhrase()));
        ANSI.prompt();
    }

    private void download(String content) throws IOException {
        block32: {
            try {
                Map.Entry<ProcessBuilder, InfoPacket> entry = EndPoint.getDownloader(content);
                ProcessBuilder builder = entry.getKey();
                InfoPacket info = entry.getValue();
                if (info.isSet(info.error)) {
                    if (this.session != null && this.session.isOpen()) {
                        this.session.getBasicRemote().sendText(PACKET.ERROR.value + info.error);
                    }
                    break block32;
                }
                if (this.session != null && this.session.isOpen()) {
                    this.session.getBasicRemote().sendText(PACKET.INFOPACKET.value + info.toString());
                }
                Process process = builder.start();
                try (InputStream input = process.getInputStream();
                     BufferedReader error = process.errorReader();){
                    long time = System.currentTimeMillis();
                    boolean onExit = false;
                    while (process.isAlive()) {
                        if (!(onExit || this.session != null && this.session.isOpen())) {
                            ANSI.raw("[BR]");
                            ANSI.raw("Download process terminated because it appears, ws-client is gone.");
                            info.error = "Download terminated because client gone.";
                            process.destroy();
                            continue;
                        }
                        int avail = input.available();
                        if (avail > 0) {
                            String[] temp;
                            time = System.currentTimeMillis();
                            String line2 = new String(input.readNBytes(avail)).trim();
                            if (line2.contains("[Metadata]") && (temp = line2.split("\"")).length > 0) {
                                info.local_filename = temp[1];
                            }
                            if (Config.DEBUG.booleanValue()) {
                                this.session.getAsyncRemote().sendText(PACKET.INFO.value + line2);
                            } else if (line2.toLowerCase().startsWith("[download]")) {
                                this.session.getAsyncRemote().sendText(line2);
                            }
                        }
                        if (System.currentTimeMillis() - time <= Config.DOWNLOADER.TIMEOUT_SECONDS * 1000L) continue;
                        ANSI.raw("[BR]");
                        ANSI.raw(String.format("Download process terminated because it appears, process is stalled since %n minutes.", Config.DOWNLOADER.TIMEOUT_SECONDS / 60L));
                        process.destroy();
                        info.error = "Download terminated because process is stalled.";
                    }
                    if (error != null && error.ready()) {
                        ANSI.raw("[BR]");
                        error.lines().forEach(line -> ANSI.warn(line));
                    }
                }
                if (process.isAlive()) {
                    process.destroy();
                }
                ANSI.raw("[BR]");
                if (info.downloadable.booleanValue() && Config.MYSQL.USE.booleanValue() && !info.isSet(info.error)) {
                    File file = new File(builder.directory().getAbsolutePath() + "/" + info.local_filename);
                    if (file.exists() && file.isFile() && file.canRead()) {
                        MakeDownloadable downloadable = new MakeDownloadable(file, info.temp);
                        Optional<String> optLink = downloadable.future.get(2L, TimeUnit.MINUTES);
                        optLink.ifPresentOrElse(link -> {
                            if (this.session != null && this.session.isOpen()) {
                                this.session.getAsyncRemote().sendText(PACKET.READY.value + link);
                            }
                        }, () -> {
                            if (this.session != null && this.session.isOpen()) {
                                this.session.getAsyncRemote().sendText(PACKET.ERROR.value + "Failed to create downloadable file.");
                            }
                        });
                    } else if (this.session != null && this.session.isOpen()) {
                        this.session.getAsyncRemote().sendText(PACKET.ERROR.value + "Downloaded file not found or readable.");
                    }
                }
            }
            catch (Exception e) {
                if (this.session != null && this.session.isOpen()) {
                    this.session.getBasicRemote().sendText(PACKET.ERROR.value + "Download failed.");
                }
                ANSI.raw("[BR]");
                ANSI.error("Error while looping yt-dlp process.", e);
            }
        }
        if (this.session != null) {
            this.session.close();
        }
    }

    private static Map.Entry<ProcessBuilder, InfoPacket> getDownloader(String url) {
        Optional<File> opt = Helper.getOrCreateMediaDir(Config.DOWNLOADER.ROOT_PATH);
        if (opt.isEmpty()) {
            return null;
        }
        File directory = opt.get();
        return Helper.createDownloadBuilder(directory, String.format("--tor --link --temp %s", url));
    }

    public class PingRunner
    implements Runnable {
        long interval = 1000L;

        @Override
        public void run() {
            while (EndPoint.this.session.isOpen()) {
                try {
                    EndPoint.this.session.getBasicRemote().sendPing(ByteBuffer.allocate(0));
                }
                catch (IOException | IllegalArgumentException e) {
                    try {
                        EndPoint.this.session.close(new CloseReason(CloseReason.CloseCodes.CLOSED_ABNORMALLY, "Ping failed."));
                    }
                    catch (IOException e1) {
                        ANSI.error("Ping fail: Close session failed.", e);
                        ANSI.prompt();
                    }
                    break;
                }
                try {
                    Thread.sleep(this.interval);
                }
                catch (InterruptedException e) {
                    ANSI.error("Ping fail: Thread interrupted.", e);
                    ANSI.prompt();
                }
            }
        }
    }

    private static enum PACKET {
        ACCEPT("{%ACPT%}"),
        INFO("{%INF%}"),
        INFOPACKET("{%INFPKT%}"),
        READY("{%RDY%}"),
        ERROR("{%ERR%}");

        public final String value;

        private PACKET(String string2) {
            this.value = string2;
        }
    }
}

